#|(defun tukey-hinges (var)
  (let* ((var (coerce var 'vector))
         (n (length var))
         (sorted-var (sort-data var))
         (median (median var))
         (length-hinge (if (evenp n) (/ n 2) (/ (1+ n) 2)))
         (low-hinge (median (select sorted-var (iseq  0 length-hinge))))
         (high-hinge (median (select sorted-var (iseq  length-hinge (1- n)))))
         (low-whisker (- low-hinge (* 1.5 (- high-hinge low-hinge))))
         (high-whisker (+ high-hinge (* 1.5 (- high-hinge low-hinge))))
         (extreme-low-whisker (- low-hinge (* 3 (- high-hinge low-hinge))))
         (extreme-up-whisker (+ high-hinge (* 3 (- high-hinge low-hinge))))
         (low-values (which (map 'vector #'(lambda (l e) (and l e))
                             (< low-whisker var) (> extreme-low-whisker var))))
         (extreme-low-values (which (< var extreme-low-whisker )))
         (high-values (which (map 'vector #'(lambda (l e) (and l e))
                             (> high-whisker var) (< extreme-up-whisker var ))))
         (extreme-up-values (which (> var extreme-up-whisker ))))
    (list 
     (list extreme-low-whisker low-whisker low-hinge median high-hinge high-whisker extreme-up-whisker) 
          (list  extreme-low-values low-values high-values extreme-up-values))))|#

         
         
;Forrest. I have not been very happy not using the tukey definition of boxplots
;this code uses Tukey's definition and I think should be used instead of the current
;I have also changed the thickness of the lines. I think they look better but...you are the boss



(defun tukey-hinges (var)
   (let* ((var (coerce var 'vector))
          (n (length var))
          (sorted-var (sort-data var))
          (median (median var))
          (length-hinge (if (evenp n) (/ n 2) (/ (1+ n) 2)))
          (low-hinge (if (= length-hinge 1) (select sorted-var 0) (median (select sorted-var (iseq  0 length-hinge)))))
          (high-hinge (if (= length-hinge 1) (select sorted-var 0) (median (select sorted-var (iseq  length-hinge (1- n))))))
          (width-hinges (* 1.5 (- high-hinge low-hinge)))
          (low-whisker (select var (which (>= var (- low-hinge width-hinges)))))
          (low-whisker (if (> (length low-whisker) 0) (first (sort-data low-whisker)) low-hinge))
          (high-whisker (select var (which (<= var (+ high-hinge width-hinges)))))
          (high-whisker (if (> (length high-whisker) 0) (first (last (sort-data high-whisker))) high-hinge)))
                      
     (list low-whisker low-hinge median high-hinge high-whisker)))


(defmeth boxplot-proto :add-boxplot 
  (y &key (x 1.0) (width 1) (lwidth 1) (color nil) (draw t)) ;PV modified this to accept color and lwidth arguments
  (unless (= 2 (send self :num-variables)) (error "only works for 2D plots"))
  (let* ((color (if color color
                    (if (and (send (send self :button-overlay) :color-mode) 
                             (> *color-mode* 0)) 'red 'black)))
         (half-box (* 0.4 width))
         (half-foot (* 0.30 width))
         ;(fiv (fivnum y))
         (tukey (tukey-hinges y));modified to use tukey hinges
         (low (first tukey))
         (q1 (second tukey))
         (med (third tukey))
         (q3 (fourth tukey))
         (high (fifth tukey))
         (num-lines-b4 (send self :num-lines))
         (lwidth lwidth)
         (first-interval-confidence (+ med (* 1.58 (/ (- q3 q1) (sqrt (length y))))))
         (second-interval-confidence (- med (* 1.58 (/ (- q3 q1) (sqrt (length y))))))
         (fourth-box (/ half-box 4))
         )
    ;this adds intervals of confidence around the median
 
 
    (send self :add-lines (list (- x fourth-box) (+ x fourth-box))
                         (list med med) :color 'orange :width lwidth)
 (send self :add-lines (list (- x fourth-box) (- x fourth-box))
          (list first-interval-confidence second-interval-confidence) :color 'cyan :width lwidth)
    (send self :add-lines (list (+ x fourth-box) (+ x  fourth-box))
          (list first-interval-confidence second-interval-confidence) :color 'cyan :width lwidth)
(send self :add-lines (list (- x fourth-box) (+ x fourth-box))
                         (list med med) :color 'cyan :width lwidth)

    (send self :add-lines (list (- x fourth-box) (+ x fourth-box))
          
          (list first-interval-confidence first-interval-confidence) :color 'cyan :width lwidth)

    (send self :add-lines (list (- x fourth-box) (+ x fourth-box))
          (list second-interval-confidence second-interval-confidence) :color 'cyan :width lwidth)



    (send self :add-lines (list x x) (list q3 high) :color color :width lwidth)
    (send self :add-lines (list x x) (list q1 low) :color color :width lwidth)
    (send self :add-lines (list (- x half-foot) (+ x half-foot))
                          (list low low) :color color :width lwidth)
    (send self :add-lines (list (- x half-box) (+ x half-box))
                          (list med med) :color color :width lwidth)
    (send self :add-lines (list (- x half-foot) (+ x half-foot))
                          (list high high) :color color :width lwidth)
    (send self :add-lines (list (- x half-box) (- x half-box) 
                                (+ x half-box) (+ x half-box) (- x half-box))
                          (list q3 q1 q1 q3 q3) :color color :width lwidth)

    (send self :add-lines (list (- x half-box) (- x half-box) 
                               (+ x half-box) (+ x half-box) (- x half-box))
                         (list q3 q1 q1 q3 q3) :color color :width lwidth)


           
    ))

;;this version of the boxplot computes individual intervals of confidence for the means
;; NOTE It uses t-1 for the interval
(defmeth boxplot-proto :add-diamondplot 
  (y &key (x 1.0) (width 1.0) (draw t))
  (unless (= 2 (send self :num-variables)) (error "only works for 2D plots"))
  (let* ((color (if (and (send (send self :button-overlay) :color-mode) 
                         (> *color-mode* 0)) 'green 'black))
         (half-box (* 0.5 width))
         (half-foot (* 0.1 width))
         (mean (mean y))
         (stdv (* (t-quant .975 (- (length y) 1)) 
                  (/ (standard-deviation y) 
                     (sqrt (length y)))));intervals of confidence about the mean
         (low (min y))
         (p1 (- mean (if stdv stdv 0)))
         (p3 (+ mean (if stdv stdv 0)))
         (high (max y)))
(print mean)
(print (/ (standard-deviation y) 
                     (sqrt (length y))))
(print (list p1 p3))
    (send self :add-lines (list (- x half-box) (+ x half-box))
                          (list mean mean) :color color :width 1)
    (send self :add-lines (list x (- x half-box) x (+ x half-box) x)
                          (list p3 mean p1 mean p3) :color color :width 1)
    ))